#include <QtGui>
#include "mode1/DrawERDlg.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/Attribute.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode2/TablePages.h"
#include "mode1/SHtableAttributeDlg.h"
#include "mode1/SHtableRelationDlg.h"

Table::Table(QPointF point, QString length, QGraphicsItem * parent) : QGraphicsRectItem(parent)
{
	this->rect = QRectF(point.x(),point.y(),102,77);
	this->setRect(this->rect);
	this->setFlag(QGraphicsItem::ItemIsMovable);
	this->setFlag(QGraphicsItem::ItemIsSelectable);
	this->setPen(QPen(Qt::white));
	this->setBrush(QBrush(Qt::white));

	this->nameRect = new NameRect(rect, length, this);
	this->primaryRect = new PrimaryKeysRect(rect, this);
	this->attributesRect = new AttributesRect(rect, this);
}

void Table::SetPosition(int state)
{
	if( state == 1 ){
		this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y(), this->boundingRect().width(), 
				this->boundingRect().height()+16);
	}
	else if( state == 0 ){
		this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y(), this->boundingRect().width(), 
			this->boundingRect().height()-16);
	}

	this->setRect(this->rect);
}

void Table::AddArrow(Arrow* arrow)
{
	this->arrows << arrow;
}

QVariant Table::itemChange(GraphicsItemChange change, const QVariant &value)
{
    if (change == QGraphicsItem::ItemPositionChange) {

		for(int i=0; i<this->arrows.count(); i++){
			(this->arrows)[i]->updatePosition();
		}
        
	/*	if( ((Canvas*)(this->scene()))->GetArrow() != 0 ){
			qDebug() << "TableChange";
			((Canvas*)(this->scene()))->GetArrow()->updatePosition();
		}*/
    }
	
    return value;
}

void Table::SetRect(double gap)
{
	// ̺ ؽƮ â ũ ... 
	this->setRect(this->boundingRect().x(), this->boundingRect().y(), this->boundingRect().width()+gap,
		this->boundingRect().height());
	this->primaryRect->setRect(this->primaryRect->boundingRect().x(), this->primaryRect->boundingRect().y(), 
		this->primaryRect->boundingRect().width()+gap, this->primaryRect->boundingRect().height());
	
	this->nameRect->setRect(this->nameRect->boundingRect().x(), this->nameRect->boundingRect().y(), 
		this->nameRect->boundingRect().width()+gap, this->nameRect->boundingRect().height());;
	
	this->attributesRect->setRect(this->attributesRect->boundingRect().x(), this->attributesRect->boundingRect().y(), 
		this->attributesRect->boundingRect().width()+gap, this->attributesRect->boundingRect().height());
}

void Table::ReSize()
{	
	double maxTextSize = 0.0;

	QRectF rect1;
	QRectF rect2;

	maxTextSize = this->nameRect->GetName()->boundingRect().width();

	// PK  ġ   ũ 
	if( this->GetPrimaryRect()->GetPrimaryKeys().count() > 0){

		rect1 = QRectF(this->GetPrimaryRect()->boundingRect().x(), this->GetPrimaryRect()->boundingRect().y(), 
			this->GetPrimaryRect()->boundingRect().width(), this->GetPrimaryRect()->boundingRect().height());

		PrimaryKey* primaryKey;

		for(int i=0; i<this->GetPrimaryRect()->GetPrimaryKeys().count(); i++){
			primaryKey = (this->GetPrimaryRect()->GetPrimaryKeys())[i];

			if( maxTextSize < primaryKey->boundingRect().width() ){
				maxTextSize = primaryKey->boundingRect().width();
			}
			
			primaryKey->setPos( rect1.x() + 5, (rect1.y() + 2) + 16 * i);
		}	
		
		this->GetPrimaryRect()->setRect(rect1.x(), rect1.y(), maxTextSize + 7, 
			25 + 16 * (this->GetPrimaryRect()->GetPrimaryKeys().count()-1));
	}
	
	if( this->GetAttributesRect()->GetAttributes().count() > 0){
		
		rect2 = QRectF(this->GetAttributesRect()->boundingRect().x(), this->GetAttributesRect()->boundingRect().y(), 
			this->GetAttributesRect()->boundingRect().width(), this->GetAttributesRect()->boundingRect().height());
		
		Attribute* attribute;

		this->GetAttributesRect()->setRect(rect2.x(), this->primaryRect->boundingRect().y() + this->primaryRect->boundingRect().height()
		, maxTextSize + 7, 25 + 26 * (this->attributesRect->GetAttributes().count() - 1));
		
		for(int i=0; i<this->GetAttributesRect()->GetAttributes().count(); i++){
			attribute = (this->GetAttributesRect()->GetAttributes())[i];
			
			if( maxTextSize < attribute->boundingRect().width() ){
				maxTextSize = attribute->boundingRect().width();
			}
			
			attribute->setPos( this->GetAttributesRect()->boundingRect().x() + 5, 
				(this->GetAttributesRect()->boundingRect().y() + 2) + 16 * i );
		}
	}
	
	this->GetAttributesRect()->setRect(rect2.x(), this->primaryRect->boundingRect().y() + this->primaryRect->boundingRect().height()
		, maxTextSize + 7, 25 + 16 * (this->attributesRect->GetAttributes().count() - 1));
	
	this->GetPrimaryRect()->setRect(this->primaryRect->boundingRect().x(), this->primaryRect->boundingRect().y(), 
		maxTextSize + 7, this->primaryRect->boundingRect().height());

	this->nameRect->setRect(this->nameRect->boundingRect().x(), this->nameRect->boundingRect().y(), 
		maxTextSize + 7, this->nameRect->boundingRect().height());

	this->setRect(this->boundingRect().x(), this->boundingRect().y(), maxTextSize + 9, 
		this->nameRect->boundingRect().height() + this->primaryRect->boundingRect().height() + 
		this->attributesRect->boundingRect().height() + 2);
}

void Table::mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * event )
{
	SHtableAttributeDlg* tableAttributeDialog = new SHtableAttributeDlg(this);
	this->scene()->clearSelection();
	tableAttributeDialog->exec();
}

Table::~Table()
{
}
